%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Investment Judgment Advisor
%%% Programed by Jhiin Joo specifically for MAC users
%%% March 3, 2009
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% COMPUTE THE LWA..
global Cs Special

L=zeros(5,9);
Ls=zeros(5,9);
%%%%%%%%%%figure
for k=1:5
    tempf_nega=Xs(k,1:2); %% MFs for the linguistic ratings
    tempf=Xs(k,3);
    temps=Xs(k,4);
    MFs1_nega=MFsf_nega(tempf_nega,:);
    MFs1=MFsf(tempf,:);
    MFs2=MFss(temps,:);
    MFs=[MFs1_nega; MFs1; MFs2];
    
    tempw1=Ws(1:2); %% MFs for the linguistic weights
    tempw2=Ws(3);
    tempw3=Ws(4);
    MFsw1=MFs_w(tempw1,:);
    MFsw2=MFs_ww(tempw2,:);
    MFsw3=MFs_w(tempw3,:);
    MFsw=[MFsw1; MFsw2; MFsw3]; 
        
    LWA=LWA9(MFs,MFsw); %% LWA
    L(k,:)=LWA;
    [Cs(k), Cl(k), Cr(k)]=centroidIT2(LWA); %% centriod
    %hold on;
end

% disp('         ');    
% disp('(1) Ranking and the Centroid - Center, [Left bound, Right bound]');
% disp('      ');


[Cs,index]=sort(Cs);  %% Sort the center of the centroid
Cl=Cl(index);
Cr=Cr(index);

global a

a=zeros(5,1);
a=index;
L=L(index,:);
x1=[];x2=[];x3=[];x4=[];x5=[];
%% Ranking for the five alternatives

for k=1:5

    switch a(6-k)
        case 1
            x1=[Cs(6-k) Cl(6-k)  Cr(6-k)];
        case 2
            x2=[Cs(6-k) Cl(6-k)  Cr(6-k)];
        case 3
            x3=[Cs(6-k) Cl(6-k)  Cr(6-k)];
        case 4
            x4=[Cs(6-k) Cl(6-k)  Cr(6-k)];
        case 5
            x5=[Cs(6-k) Cl(6-k)  Cr(6-k)];
    end
    Ls(k,:)=L(6-k,:);
end

global xxs xxl xxr
global xxsm xxsl xxsr


xxs=[x1(1); x2(1); x3(1); x4(1); x5(1)]; %%Ranking Band
xxl=[x1(2); x2(2); x3(2); x4(2); x5(2)];
xxr=[x1(3); x2(3); x3(3); x4(3); x5(3)];
xxsm=[10-x1(1); 10-x2(1); 10-x3(1); 10-x4(1); 10-x5(1)]; %% RIsk Band
xxsl=[10-x1(2); 10-x2(2); 10-x3(2); 10-x4(2); 10-x5(2)];
xxsr=[10-x1(3); 10-x2(3); 10-x3(3); 10-x4(3); 10-x5(3)];

[xxs,index]=sort(xxs);
xxl=xxl(index);
xxr=xxr(index);
xxsm=xxsm(index);
xxsl=xxsl(index);
xxsr=xxsr(index);


global S
%% Jacard Similarity
S=zeros(5,5);
for i=1:5
    for k=1:5
        S(i,k)=Jaccard(Ls(i,:), Ls(k,:));
    end
end
S;

